/*_agicall_api*/
var ai_err_pending = -1;
var ai_err_no = 0;
var ai_err_timeout=-101;
var ai_err_error=-102;
var ai_err_proto=-103;
var ai_err_notsupport = 400001;
var ai_err_url = 400002;
var ai_null_param = {}
var xhr_timeout_count = 0;

function cls_ub_phone_api() {
    var m_proto='';
    var m_url = '';
    var m_account = '';
    var m_pwd = '';
    var m_charset = 'utf-8';
    var m_logout = true;
    var m_timeout_ms = 1000;
    var m_async = true;
    var m_pipe_id = 0;
    var m_wait_pipe_delay = 500;
    var m_pop_evt_delay = 500;
    var m_pop_evt_timer = 500;
    var m_b_start = false;
    var m_pipe_ep_acc = '';
    var m_pipe_class = '';
    var m_pipe_charset = '';
    var m_xhr_timeout_count = 0;
    var m_last_pop_evt_tick = 0;
    var m_ws_post = null;
    var self = this;

    this.get_version = function () { return "24.09.21"; }
    this.set_url = function (url) { m_url = url; }
    this.get_url = function() { return m_url;}
    this.set_timeout_ms = function (ms) { m_timeout_ms = ms; }
    this.set_async = function (b) { m_async = b; }
    this.set_account = function (acc, pwd) { m_account = acc; m_pwd = pwd; }    
    this.set_logout = function (b) { m_logout = b; }
    this.set_charset = function (c) { m_charset = c; }
    this.get_logout = function () { return m_logout; }
    this.get_pipe_id = function () { return m_pipe_id; }
    this.reset_pipe_id = function () { m_pipe_id = 0; }
    this.reset_last_pop_evt_tick = function() { m_last_pop_evt_tick = 0; }
    this.set_evt_delay = function (delay) { m_pop_evt_delay = delay;}
    this.set_wait_delay = function(delay) { m_wait_pipe_delay = delay; }
    this.get_evt_delay = function () { return m_pop_evt_delay;}
    this.get_wait_delay = function() { return m_wait_pipe_delay;}
    this.get_xhr_timeout_count = function() { return m_xhr_timeout_count;}
    this.add_xhr_timeout_count = function() { m_xhr_timeout_count++;}

    this.free_ws = function()
    {
        if (m_ws_post) 
        {
            m_ws_post.do_disconnect();
            m_ws_post = null;
        }
    }

    this.set_host_addr = function (proto,ip,port) 
    { 
        if (u_isEmpty(proto)) m_proto = "ws";
        else m_proto = proto;
        m_url = m_proto + "://" + ip + ":" + port + "/r_api/v1";

        if (m_proto == 'ws')
        {
            this.free_ws();
            m_ws_post = new ws_post_json(this.create_url('agi_ub_ws_upgrade'));
            m_ws_post.on_message = function (s_data) { self.on_xhr_response_msg(s_data); }  
            m_ws_post.on_error = function(){self.on_xhr_error(m_url + "/agi_ub_evt_create_json_pipe?" + "");}
            m_ws_post.on_disconnected = function(){self.on_xhr_error(m_url + "/agi_ub_evt_disconnected?" + "");}
            m_ws_post.do_connect();
        }
    }

    this.create_url = function (func_name) {
        return m_url + "/" + func_name + "?" + "r_api_account=" + m_account + "&r_api_pwd=" + m_pwd;
    }
    this.create_url_ = function (func_name, user_id) {
        return this.create_url(func_name) + "&r_api_user_id=" + user_id;
    }

    this.on_xhr_response_msg = function (s_data) {
        this.reset_last_pop_evt_tick();               
        var json_response = JSON.parse(s_data);
        var json_data = json_response['data'];
        //u_logout('data:' + JSON.stringify(json_data));
        var func_name = json_data["func_name"];
        if (func_name == 'agi_ub_evt_create_json_pipe') {
            if (!m_b_start) return 0;
            if (json_data['err_id'] > 0x4d00000)
            {
                m_pipe_id = json_data['err_id'];
                json_data['err_id'] = 0;
                u_logout('create pipe successed:' + m_pipe_id);
                this.on_agi_ub_finished(json_data);
            }
            else{
                u_logout('**create pipe failed:' + json_data['err_id']);
                this.on_agi_ub_finished(json_data);
            }
        }
        else if (func_name == 'agi_ub_evt_pop_json_buf_data') {
            if (!m_b_start) return 0;
            var err_id = json_data['err_id'];
            if (err_id == 0) {
                //u_logout(JSON.stringify(json_data));
                this.on_pop_evt_successed(json_data['result']);
                this.agi_ub_evt_pop_json_buf_data(m_pipe_id, 0);
            }
            else if (err_id == 80000005) {//pipe id error, recreate?
                u_logout('**pipe id error->recreate**');
                m_pipe_id = 0;
            }
        }
        else if (func_name == 'agi_ub_evt_destroy_json_pipe') 
        {
            if (m_proto == 'ws' && m_ws_post)
            {
                m_ws_post.do_disconnect();
            }
        }
        else {
            this.on_agi_ub_finished(json_data);
        }
        return 1;
    }
    this.on_xhr_error = function(url, func_param)
    {       
        this.reset_last_pop_evt_tick();
        let urlObj = new URL(url);
        let pathName = urlObj.pathname;
        let func_name = pathName.split('/').pop();
        var json_data = {
            'func_name':func_name,
            'func_param':func_param,
            'err_desc':'url error',
            'err_id': ai_err_error
        }            
        m_pipe_id = 0;  
        u_logout('**on_xhr_error reset pipe id**');
        if (!m_b_start) 
        {
            if (func_name == 'agi_ub_evt_create_json_pipe' || func_name == 'agi_ub_evt_pop_json_buf_data') return 0;
        }
        if (!m_b_start)  return 0;
        this.on_agi_ub_finished(json_data);
        return 1;
    }
    this.on_xhr_timeout = function(url, func_param)
    {       
        this.reset_last_pop_evt_tick();
        this.add_xhr_timeout_count();
        if (this.get_xhr_timeout_count() % 20 == 0) 
        {
            u_logout('xhr timeout:'+ this.get_xhr_timeout_count() + ' ' + url);
        }
        if (this.get_xhr_timeout_count() > 3)
        {
            this.reset_pipe_id();
        }
        let urlObj = new URL(url);
        let pathName = urlObj.pathname;
        let func_name = pathName.split('/').pop();
        var json_data = {
            'func_name':func_name,
            'func_param':func_param,
            'err_desc':'url timeout',
            'err_id': ai_err_timeout
        }            

        if (!m_b_start) 
        {
            if (func_name == 'agi_ub_evt_create_json_pipe' || func_name == 'agi_ub_evt_pop_json_buf_data') return 0;
        }

        this.on_agi_ub_finished(json_data);
        return 1;
    }
    this.post_http = function (url, func_param) {
        var xhr_http = new xhr_post_json(url, m_timeout_ms, '');
        xhr_http.on_message = function (s_data) { self.on_xhr_response_msg(s_data); }        
        xhr_http.on_timeout = function(send_data){ self.on_xhr_timeout(url, func_param); }
        xhr_http.on_error = function(err_id){ self.on_xhr_error(url, func_param); }
        var json_param = {
            'func_param': func_param
        }
        xhr_http.send_json(json_param, m_async);
        return ai_err_no;
    }

    this.post_ws = function (url, func_param) {
        if (m_ws_post.get_ready_state() == WebSocket.OPEN)
        {
            var json_param = {
                'action':'r_api',
                'url':url,
                'func_param': func_param
            }
            return m_ws_post.send(JSON.stringify(json_param), m_timeout_ms, '');
        }
        else return ai_err_error;
    }

    this.post_url = function (url, func_param) {
        if (m_url.length <= 0) return ai_err_url;

        if (m_proto == "http")  return this.post_http(url, func_param);
        else if(m_proto == "ws")  return this.post_ws(url, func_param);
        else return ai_err_proto;
    }

    this.create_json_pipe = function (ep_acc, class_name, charset) {
        var func_param = {
            'ep_acc': ep_acc,
            'class_name': class_name,
            'charset': charset,
            'evt_pipe_cb':true
        }
        return this.post_url(this.create_url('agi_ub_evt_create_json_pipe'), func_param);
    }
    //-----------------

    this.agi_ub_version = function () {
        return this.post_url(this.create_url('agi_ub_version'), ai_null_param);
    }

    this.agi_ub_init = function (in_json_param) {
        return ai_err_notsupport;
    }
    this.agi_ub_uninit = function () { return ai_err_notsupport; }
    this.agi_ub_isinit = function () {
        return this.post_url(this.create_url('agi_ub_isinit'), ai_null_param);
    }
    this.agi_ub_count = function () {
        return this.post_url(this.create_url('agi_ub_count'), ai_null_param);
    }
    this.agi_ub_create = function (in_json_param) { return ai_err_notsupport; }
    this.agi_ub_destroy = function (in_json_param) { return ai_err_notsupport; }
    this.aagi_ub_action = function (in_json) {
        var json_action = u_to_json_obj(in_json);
        var func_param = { 'in_json': json_action }
        return this.post_url(this.create_url('agi_ub_action'), func_param);
    }
    this.agi_ub_action_param = function (ep_acc, act_name, json_param) {
        var json_action = u_to_json_obj(json_param);
        var func_param = {
            'ep_acc': ep_acc,
            'act_name': act_name,
            'json_param': json_action
        }
        return this.post_url(this.create_url('agi_ub_action_param'), func_param);
    }
    this.agi_ub_do_ctrl = function (ep_acc, ctrl_name, value) {
        var func_param = {
            'ep_acc': ep_acc,
            'ctrl_name': ctrl_name,
            'value': value
        }
        return this.post_url(this.create_url('agi_ub_do_ctrl'), func_param);
    }

    this.agi_ub_callout = function (ep_acc, code, json_rule, au_dev) {
        var json_rule_param = u_to_json_obj(json_rule);
        var func_param = {
            'ep_acc': ep_acc,
            'code': code,
            'json_rule': json_rule_param,
            'au_dev': au_dev
        }
        return this.post_url(this.create_url('agi_ub_callout'), func_param);
    }

    this.agi_ub_dial_dtmf = function (ep_acc, code) {
        var func_param = {
            'ep_acc': ep_acc,
            'code': code
        }
        return this.post_url(this.create_url('agi_ub_dial_dtmf'), func_param);
    }
    this.agi_ub_answer = function (ep_acc, au_dev) {
        var func_param = {
            'ep_acc': ep_acc,
            'au_dev': au_dev
        }
        return this.post_url(this.create_url('agi_ub_answer'), func_param);
    }
    this.agi_ub_hangup = function (ep_acc) {
        var func_param = {
            'ep_acc': ep_acc
        }
        return this.post_url(this.create_url('agi_ub_hangup'), func_param);
    }
    this.agi_ub_playfile_start = function (ep_acc, file, repeat_cnt) {
        var func_param = {
            'ep_acc': ep_acc,
            'file': file,
            'repeat_cnt': repeat_cnt
        }
        return this.post_url(this.create_url('agi_ub_playfile_start'), func_param);
    }
    this.agi_ub_playfile_stop = function (ep_acc, uuid) {
        var func_param = {
            'ep_acc': ep_acc,
            'uuid': uuid
        }
        return this.post_url(this.create_url('agi_ub_playfile_stop'), func_param);
    }
    this.agi_ub_recfile_start = function (ep_acc, file) {
        var func_param = {
            'ep_acc': ep_acc,
            'file': file
        }
        return this.post_url(this.create_url('agi_ub_recfile_start'), func_param);
    }
    this.agi_ub_recfile_stop = function (ep_acc, uuid) {
        var func_param = {
            'ep_acc': ep_acc,
            'uuid': uuid
        }
        return this.post_url(this.create_url('agi_ub_recfile_stop'), func_param);
    }
    this.agi_ub_playbuf_start = function (ep_acc, json_param) { return ai_err_notsupport; }
    this.agi_ub_playbuf_stop = function (ep_acc, uuid) { return ai_err_notsupport; }
    this.agi_ub_playbuf_send = function (ep_acc, uuid, audio_buf, audio_size) { return ai_err_notsupport; }
    this.agi_ub_recbuf_start = function (ep_acc, p_recbuf_callback, ptr_user_data, json_param) { return ai_err_notsupport; }
    this.agi_ub_recbuf_stop = function (ep_acc, uuid, son_param) { return ai_err_notsupport; }
    this.agi_ub_recbuf_recv = function (ep_acc, uuid, out_audio_buf, audio_buf_num) { return ai_err_notsupport; }

    this.agi_ub_acc_info = function (ep_acc) {
        var func_param = {
            'ep_acc': ep_acc
        }
        return this.post_url(this.create_url('agi_ub_acc_info'), func_param);
    }
    this.agi_ub_acc_function = function (ep_acc, func_name) {
        var func_param = {
            'ep_acc': ep_acc,
            'func_name': func_name
        }
        return this.post_url(this.create_url('agi_ub_acc_function'), func_param);
    }

    this.agi_ub_evt_create_json_pipe = function (ep_acc, class_name, charset) {
        //u_logout('start create pipe');
        m_b_start = true;
        m_pipe_ep_acc = ep_acc;
        m_pipe_class = class_name;
        m_pipe_charset = charset;

        window.setTimeout(function (self_obj) { self_obj.on_pop_evt_json_data() }, m_pop_evt_timer, self);
        return ai_err_no;
    }

    this.agi_ub_evt_destroy_json_pipe = function (pipe_id) {   
        m_b_start = false;
        if (m_pipe_id == 0) return ai_err_no;
        var func_param = {
            'pipe_id': pipe_id
        }
        m_pipe_id = 0;       
        return this.post_url(this.create_url('agi_ub_evt_destroy_json_pipe'), func_param);
    }

    this.agi_ub_evt_pop_json_buf_data = function (pipe_id, timeout_ms) {
        if (pipe_id > 0 && m_b_start) {
            var func_param = {
                'pipe_id': pipe_id,
                'timeout_ms': timeout_ms
            }
            return this.post_url(this.create_url('agi_ub_evt_pop_json_buf_data'), func_param);
        }
        else {
            return ai_err_pending;
        }
    }

    this.agi_ub_evt_get_json_buf_size = function (pipe_id, timeout_ms) {
        var func_param = {
            'pipe_id': pipe_id,
            'timeout_ms': timeout_ms
        }
        return this.post_url(this.create_url('agi_ub_evt_get_json_buf_size'), func_param);
    }
    this.agi_ub_evt_set_json_source = function (pipe_id, source_name) {
        var func_param = {
            'pipe_id': pipe_id,
            'source_name': source_name
        }
        return this.post_url(this.create_url('agi_ub_evt_set_json_source'), func_param);
    }
    this.agi_ub_evt_create_json_cb = function (ptr_func_cb, ptr_user_data, ep_acc, class_name, charset) { return ai_err_notsupport; }
    this.agi_ub_evt_destroy_json_cb = function (ptr_func_cb, ptr_user_data) { return ai_err_notsupport; }
    this.agi_ub_evt_destroy_json_cb_id = function (cb_id) { return ai_err_notsupport; }
    this.agi_ub_evt_set_json_cb_source = function (ptr_func_cb, ptr_user_data, source_name) { return ai_err_notsupport; }

    this.agi_ub_evt_push_event_source_mask = function (source_name, ep_acc, class_name, json_evt_data, mask) {
        var json_evt_data_obj = u_to_json_obj(json_evt_data);
        var func_param = {
            'source_name': source_name,
            'ep_acc': ep_acc,
            'class_name': class_name,
            'json_evt_data': json_evt_data_obj,
            'mask': mask
        }
        return this.post_url(this.create_url('agi_ub_evt_push_event_source_mask'), func_param);
    }
    this.agi_ub_evt_get_ws_json_skt = function () { return ai_err_notsupport; }
    this.agi_ub_evt_get_http_json_skt = function () { return ai_err_notsupport; }

    //--------------
    this.on_pop_evt_json_data = function () {
        if (m_b_start) {
            let tickCount = Date.now();
            if (m_last_pop_evt_tick == 0 || tickCount >= m_last_pop_evt_tick + m_timeout_ms)
            {
                m_last_pop_evt_tick =  tickCount;
                if (m_proto == 'ws' && m_ws_post && !m_ws_post.is_open())
                {
                    m_ws_post.do_connect();
                    m_pop_evt_timer = m_wait_pipe_delay + m_timeout_ms;
                }
                else
                {
                    if (m_pipe_id > 0) {
                        //u_logout("->>>>>agi_ub_evt_pop_json_buf_data");
                        //this.agi_ub_evt_pop_json_buf_data(m_pipe_id, 0);
                        m_pop_evt_timer = m_pop_evt_delay;
                    }
                    else {
                        u_logout("->>>>>create_json_pipe");
                        this.create_json_pipe(m_pipe_ep_acc, m_pipe_class, m_charset);
                        m_pop_evt_timer = m_wait_pipe_delay;
                    }
                }
            }
            u_logout("<<<<<-settimeout check pipe id->pop evt json :" + m_pop_evt_timer);
            window.setTimeout(function (self_obj) { self_obj.on_pop_evt_json_data() }, m_pop_evt_timer, self);
        }
        return ai_err_no;
    }
    //--
    this.on_pop_evt_successed = function (json_evt) { }
    this.on_agi_ub_finished = function (json_data) { }
}


function ws_post_json(url) {
    var m_ws_ = null;
    var m_url = url;
    var self = this;

    this.get_url = function(){ return m_url;}
    this.free_ws = function () {
        if (m_ws_) {
            m_ws_.close();
            m_ws_ = null;
        }
        return ai_err_no;
    }

    this.do_connect = function()
    {
        self.free_ws();
        m_ws_ = new WebSocket(m_url);
        m_ws_.onopen = self.onopen_ws;
        m_ws_.onmessage = self.onmessage_ws;
        m_ws_.onerror = self.onerror_ws;
        m_ws_.onclose = self.onclose_ws;
    }
    this.is_connected = function () { return self.is_open(); }
    //0:CONNECTING/1:open/2:closing/3:closed
    this.is_open = function () {
        return (m_ws_ != null && m_ws_.readyState == WebSocket.OPEN) ? true : false;
    }
    this.send = function (s_data, timeout, op_key) {
        if (self.is_open()) {
            m_ws_.send(s_data);
            return ai_err_no;
        }
        else {
            return ai_err_not_open;
        }
    }
    this.do_disconnect = function()
    {
        self.free_ws();
    }

    this.get_ready_state = function()
    {
        if (m_ws_) return m_ws_.readyState;
        else return 0; 
    }
    this.onopen_ws = function () {
        u_logout('ws on open->' + self.get_url());
        self.on_connected();
    }

    this.onerror_ws = function () {            
        u_logout('ws on error->' + self.get_url());
        self.free_ws();
        self.on_error();
    }

    this.onclose_ws = function () {
        if (m_ws_) 
        {
            u_logout('ws on close:' + self.get_url());
            m_ws_ = null;
        }
        self.on_disconnected();
    }

    this.onmessage_ws = function (ws_pkt) {//const onmessage_WS = ws_pkt => {
        if (typeof (ws_pkt.data) == 'string') {
            u_logout("ws_recv: " + ws_pkt.data);
            self.on_message(ws_pkt.data);
        }
    }

    //---
    this.on_message = function (s_data) { u_logout('on_recv_message'); }
    this.on_connected = function () { u_logout('on connected->' + url); }
    this.on_disconnected = function () { u_logout('on disconnected->' + url) }
    this.on_error = function () { u_logout('on_error'); }

}

function xhr_post_json(url, timeout, op_key) {
    var m_timeout = timeout;
    var m_url = url;
    var m_op_key = op_key;
    var m_begin_time = new Date().getTime();
    var self_xhr = this;
    var create_XHR = function () {
        var XHR = [
            function () { return new XMLHttpRequest() },
            function () { return new ActiveXObject("Msxml2.XMLHTTP") },
            function () { return new ActiveXObject("Msxml3.XMLHTTP") },
            function () { return new ActiveXObject("Microsoft.XMLHTTP") }
        ];
        var xhr_ = null;
        for (var i = 0; i < XHR.length; i++) {
            try {
                xhr_ = XHR[i]();
            } catch (e) {
                continue;
            }
            break;
        }
        return xhr_;
    }

    this.send = function (s_data, async) {
        var xhr = create_XHR();
        xhr.timeout = m_timeout;
        xhr.open('POST', m_url, true);
        xhr.withCredentials = false;
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.ontimeout = function (e) {self_xhr.on_timeout(s_data);}
        xhr.onerror = function () {self_xhr.on_error(0);}
        xhr.onload = function () {/*u_logout('onload');*/ }
        xhr.onloadstart = function () {/*u_logout('onloadstart' + ':' + m_url);*/}
        xhr.onprogress = function () {/*u_logout('onprogress');*/}
        xhr.onabort = function () {/*u_logout('onabort');*/}
        xhr.onloadend = function () {self_xhr.on_close(m_op_key, xhr.readyState, xhr.status, new Date().getTime() - m_begin_time);}
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                if (xhr.status == 200) {
                    xhr_timeout_count = 0;
                    self_xhr.on_message((xhr.responseText));
                }
                else if (xhr.status > 0) {
                    self_xhr.on_error(xhr.status);
                }
            }
        }

        try {
            xhr.send(s_data);
            if (!async) {
                if (xhr.status === 200) {
                    return xhr.responseText;
                }
                else {
                    return "";
                }
            }
        } catch (error) {
            console.error('xhr send error:' + error);
        }
        return "";
    }

    this.send_json = function (json_data, async) { this.send(JSON.stringify(json_data), async);  }
    //---
    this.on_timeout = function (send_data) { }
    this.on_open = function () { }
    this.on_message = function (s_data) { u_logout('xhr msg:' + s_data); }
    this.on_error = function () { u_logout('xhr error'); }
    this.on_close = function () { /*u_logout('xhr onclose...');*/ }
}

//---------------------------------
function u_is_err_not_connected(e) {
    if (e == ai_err_not_open) return true;
    else return false;
}
function u_isNotEmpty(res) {
    if (res != undefined && res != "" && res.length > 0)
        return true;
    return false;
}
function u_isEmpty(res) {
    if (res == undefined || res == "" || res.length <= 0 || res.trim().length <= 0)
        return true;
    else return false;
}
function u_data(res) {
    if (u_isEmpty(res)) return '';
    else return res;
}

function u_setCookie() {
    var d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    var expires = "expires=" + d.toGMTString();
    document.cookie = expires;
}

function u_Format2d(v) {
    if (v < 10) return '0' + v.toString();
    else return v.toString();
}

function u_Format3d(v) {
    if (v < 10) return '00' + v.toString();
    else if (v < 100) return '0' + v.toString();
    else return v.toString();
}

function u_GetNowTimeString() {
    var vd = new Date();
    return '[' + u_Format2d(vd.getHours()) + ':' + u_Format2d(vd.getMinutes()) + ':' + u_Format2d(vd.getSeconds()) + '.' + u_Format3d(vd.getMilliseconds()) + ']';
}

function u_getutc_ms() {
    return new Date().getTime();
}

function u_md5(s) {
    return s.MD5(32);
}
function u_isArray(a) {
    if (Object.prototype.toString.call(a) === '[Object Array]'
        || Array.isArray(a)) return true;
    else return false;
}

function u_url_protocol(url)//HTTP:// -> http
{
    var v_index = url.indexOf(':');
    if (v_index > 0) {
        return url.substr(0, v_index).toLowerCase();
    }
    else return "";
}

function u_logout(s) {
    var v = u_GetNowTimeString() + ' ' + s;
    console.log(v);
}

function u_gbk2utf8(text) {
    var encode = encodeURIComponent(text);
    return decodeURIComponent(encode);
}
function u_to_json_obj(s_json)
{
    if (u_isEmpty(s_json)) s_json ='{}';
    return JSON.parse(s_json);
}