#!/bin/bash
workdir=$(cd $(dirname $0); pwd)	
cd $workdir
ARCH=$(uname -m)
if [ "${ARCH}" = "x86_64" ]; then
    export LD_LIBRARY_PATH=$workdir/agi_ub/libs/x64:$LD_LIBRARY_PATH
    ./xcphone-x64 & disown
elif [ "${ARCH}" = "aarch64" ]; then
    export LD_LIBRARY_PATH=$workdir/agi_ub/libs/aarch64:$LD_LIBRARY_PATH
    ./xcphone-aarch64 & disown
elif [ "${ARCH}" = "armv7l" ] || [ "${ARCH}" = "armv7a" ]; then
    export LD_LIBRARY_PATH=$workdir/agi_ub/libs/arm:$LD_LIBRARY_PATH
    echo "未支持的cpu类型 [${ARCH}]，请联系技术支持qq：9421766"
    sleep 5
elif [ "${ARCH}" = "i386" ] || [ "${ARCH}" = "i686" ]; then
    echo "未适配的cpu类型 [${ARCH}]，请联系技术支持qq：9421766"
    sleep 5
else
    echo "未支持的cpu类型 [${ARCH}]，请联系技术支持qq：9421766"
    sleep 5
fi

exit 0

